/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceImagePermissionRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<UpdateWorkspaceImagePermissionRequest.Builder, UpdateWorkspaceImagePermissionRequest> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(UpdateWorkspaceImagePermissionRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<Boolean> ALLOW_COPY_IMAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowCopyImage").getter(getter(UpdateWorkspaceImagePermissionRequest::allowCopyImage))
            .setter(setter(Builder::allowCopyImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCopyImage").build()).build();

    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedAccountId").getter(getter(UpdateWorkspaceImagePermissionRequest::sharedAccountId))
            .setter(setter(Builder::sharedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD,
            ALLOW_COPY_IMAGE_FIELD, SHARED_ACCOUNT_ID_FIELD));

    private final String imageId;

    private final Boolean allowCopyImage;

    private final String sharedAccountId;

    private UpdateWorkspaceImagePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.allowCopyImage = builder.allowCopyImage;
        this.sharedAccountId = builder.sharedAccountId;
    }

    /**
     * <p>
     * The identifier of the image.
     * </p>
     * 
     * @return The identifier of the image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The permission to copy the image. This permission can be revoked only after an image has been shared.
     * </p>
     * 
     * @return The permission to copy the image. This permission can be revoked only after an image has been shared.
     */
    public final Boolean allowCopyImage() {
        return allowCopyImage;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account to share or unshare the image with.
     * </p>
     * <important>
     * <p>
     * Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.
     * </p>
     * </important>
     * 
     * @return The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important>
     *         <p>
     *         Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.
     *         </p>
     */
    public final String sharedAccountId() {
        return sharedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(allowCopyImage());
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceImagePermissionRequest)) {
            return false;
        }
        UpdateWorkspaceImagePermissionRequest other = (UpdateWorkspaceImagePermissionRequest) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(allowCopyImage(), other.allowCopyImage())
                && Objects.equals(sharedAccountId(), other.sharedAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspaceImagePermissionRequest").add("ImageId", imageId())
                .add("AllowCopyImage", allowCopyImage()).add("SharedAccountId", sharedAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "AllowCopyImage":
            return Optional.ofNullable(clazz.cast(allowCopyImage()));
        case "SharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceImagePermissionRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceImagePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkspaceImagePermissionRequest> {
        /**
         * <p>
         * The identifier of the image.
         * </p>
         * 
         * @param imageId
         *        The identifier of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The permission to copy the image. This permission can be revoked only after an image has been shared.
         * </p>
         * 
         * @param allowCopyImage
         *        The permission to copy the image. This permission can be revoked only after an image has been shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCopyImage(Boolean allowCopyImage);

        /**
         * <p>
         * The identifier of the Amazon Web Services account to share or unshare the image with.
         * </p>
         * <important>
         * <p>
         * Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.
         * </p>
         * </important>
         * 
         * @param sharedAccountId
         *        The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important>
         *        <p>
         *        Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String imageId;

        private Boolean allowCopyImage;

        private String sharedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceImagePermissionRequest model) {
            super(model);
            imageId(model.imageId);
            allowCopyImage(model.allowCopyImage);
            sharedAccountId(model.sharedAccountId);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Boolean getAllowCopyImage() {
            return allowCopyImage;
        }

        public final void setAllowCopyImage(Boolean allowCopyImage) {
            this.allowCopyImage = allowCopyImage;
        }

        @Override
        public final Builder allowCopyImage(Boolean allowCopyImage) {
            this.allowCopyImage = allowCopyImage;
            return this;
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceImagePermissionRequest build() {
            return new UpdateWorkspaceImagePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
