/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum WorkspaceImageErrorDetailCode {
    OUTDATED_POWERSHELL_VERSION("OutdatedPowershellVersion"),

    OFFICE_INSTALLED("OfficeInstalled"),

    P_CO_IP_AGENT_INSTALLED("PCoIPAgentInstalled"),

    WINDOWS_UPDATES_ENABLED("WindowsUpdatesEnabled"),

    AUTO_MOUNT_DISABLED("AutoMountDisabled"),

    WORKSPACES_BYOL_ACCOUNT_NOT_FOUND("WorkspacesBYOLAccountNotFound"),

    WORKSPACES_BYOL_ACCOUNT_DISABLED("WorkspacesBYOLAccountDisabled"),

    DHCP_DISABLED("DHCPDisabled"),

    DISK_FREE_SPACE("DiskFreeSpace"),

    ADDITIONAL_DRIVES_ATTACHED("AdditionalDrivesAttached"),

    OS_NOT_SUPPORTED("OSNotSupported"),

    DOMAIN_JOINED("DomainJoined"),

    AZURE_DOMAIN_JOINED("AzureDomainJoined"),

    FIREWALL_ENABLED("FirewallEnabled"),

    VM_WARE_TOOLS_INSTALLED("VMWareToolsInstalled"),

    DISK_SIZE_EXCEEDED("DiskSizeExceeded"),

    INCOMPATIBLE_PARTITIONING("IncompatiblePartitioning"),

    PENDING_REBOOT("PendingReboot"),

    AUTO_LOGON_ENABLED("AutoLogonEnabled"),

    REAL_TIME_UNIVERSAL_DISABLED("RealTimeUniversalDisabled"),

    MULTIPLE_BOOT_PARTITION("MultipleBootPartition"),

    REQUIRES64_BIT_OS("Requires64BitOS"),

    ZERO_REARM_COUNT("ZeroRearmCount"),

    IN_PLACE_UPGRADE("InPlaceUpgrade"),

    ANTI_VIRUS_INSTALLED("AntiVirusInstalled"),

    UEFI_NOT_SUPPORTED("UEFINotSupported"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspaceImageErrorDetailCode> VALUE_MAP = EnumUtils.uniqueIndex(
            WorkspaceImageErrorDetailCode.class, WorkspaceImageErrorDetailCode::toString);

    private final String value;

    private WorkspaceImageErrorDetailCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return WorkspaceImageErrorDetailCode corresponding to the value
     */
    public static WorkspaceImageErrorDetailCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link WorkspaceImageErrorDetailCode}s
     */
    public static Set<WorkspaceImageErrorDetailCode> knownValues() {
        Set<WorkspaceImageErrorDetailCode> knownValues = EnumSet.allOf(WorkspaceImageErrorDetailCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
