/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccountLinkInvitationRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, CreateAccountLinkInvitationRequest> {
    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAccountId").getter(CreateAccountLinkInvitationRequest.getter(CreateAccountLinkInvitationRequest::targetAccountId)).setter(CreateAccountLinkInvitationRequest.setter(Builder::targetAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccountId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateAccountLinkInvitationRequest.getter(CreateAccountLinkInvitationRequest::clientToken)).setter(CreateAccountLinkInvitationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ACCOUNT_ID_FIELD, CLIENT_TOKEN_FIELD));
    private final String targetAccountId;
    private final String clientToken;

    private CreateAccountLinkInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.targetAccountId = builder.targetAccountId;
        this.clientToken = builder.clientToken;
    }

    public final String targetAccountId() {
        return this.targetAccountId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountLinkInvitationRequest)) {
            return false;
        }
        CreateAccountLinkInvitationRequest other = (CreateAccountLinkInvitationRequest)((Object)obj);
        return Objects.equals(this.targetAccountId(), other.targetAccountId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccountLinkInvitationRequest").add("TargetAccountId", (Object)this.targetAccountId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetAccountId": {
                return Optional.ofNullable(clazz.cast(this.targetAccountId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountLinkInvitationRequest, T> g) {
        return obj -> g.apply((CreateAccountLinkInvitationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String targetAccountId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountLinkInvitationRequest model) {
            super(model);
            this.targetAccountId(model.targetAccountId);
            this.clientToken(model.clientToken);
        }

        public final String getTargetAccountId() {
            return this.targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccountLinkInvitationRequest build() {
            return new CreateAccountLinkInvitationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccountLinkInvitationRequest> {
        public Builder targetAccountId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

