/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.AccessEndpoint;
import software.amazon.awssdk.services.workspaces.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.workspaces.model.InternetFallbackProtocol;
import software.amazon.awssdk.services.workspaces.model.InternetFallbackProtocolListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessEndpointConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessEndpointConfig> {
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessEndpoints").getter(AccessEndpointConfig.getter(AccessEndpointConfig::accessEndpoints)).setter(AccessEndpointConfig.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INTERNET_FALLBACK_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InternetFallbackProtocols").getter(AccessEndpointConfig.getter(AccessEndpointConfig::internetFallbackProtocolsAsStrings)).setter(AccessEndpointConfig.setter(Builder::internetFallbackProtocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetFallbackProtocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ENDPOINTS_FIELD, INTERNET_FALLBACK_PROTOCOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessEndpointConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AccessEndpoint> accessEndpoints;
    private final List<String> internetFallbackProtocols;

    private AccessEndpointConfig(BuilderImpl builder) {
        this.accessEndpoints = builder.accessEndpoints;
        this.internetFallbackProtocols = builder.internetFallbackProtocols;
    }

    public final boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public final List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    public final List<InternetFallbackProtocol> internetFallbackProtocols() {
        return InternetFallbackProtocolListCopier.copyStringToEnum(this.internetFallbackProtocols);
    }

    public final boolean hasInternetFallbackProtocols() {
        return this.internetFallbackProtocols != null && !(this.internetFallbackProtocols instanceof SdkAutoConstructList);
    }

    public final List<String> internetFallbackProtocolsAsStrings() {
        return this.internetFallbackProtocols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessEndpoints() ? this.accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInternetFallbackProtocols() ? this.internetFallbackProtocolsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEndpointConfig)) {
            return false;
        }
        AccessEndpointConfig other = (AccessEndpointConfig)obj;
        return this.hasAccessEndpoints() == other.hasAccessEndpoints() && Objects.equals(this.accessEndpoints(), other.accessEndpoints()) && this.hasInternetFallbackProtocols() == other.hasInternetFallbackProtocols() && Objects.equals(this.internetFallbackProtocolsAsStrings(), other.internetFallbackProtocolsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AccessEndpointConfig").add("AccessEndpoints", this.hasAccessEndpoints() ? this.accessEndpoints() : null).add("InternetFallbackProtocols", this.hasInternetFallbackProtocols() ? this.internetFallbackProtocolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
            case "InternetFallbackProtocols": {
                return Optional.ofNullable(clazz.cast(this.internetFallbackProtocolsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessEndpoints", ACCESS_ENDPOINTS_FIELD);
        map.put("InternetFallbackProtocols", INTERNET_FALLBACK_PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessEndpointConfig, T> g) {
        return obj -> g.apply((AccessEndpointConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> internetFallbackProtocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEndpointConfig model) {
            this.accessEndpoints(model.accessEndpoints);
            this.internetFallbackProtocolsWithStrings(model.internetFallbackProtocols);
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInternetFallbackProtocols() {
            if (this.internetFallbackProtocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.internetFallbackProtocols;
        }

        public final void setInternetFallbackProtocols(Collection<String> internetFallbackProtocols) {
            this.internetFallbackProtocols = InternetFallbackProtocolListCopier.copy(internetFallbackProtocols);
        }

        @Override
        public final Builder internetFallbackProtocolsWithStrings(Collection<String> internetFallbackProtocols) {
            this.internetFallbackProtocols = InternetFallbackProtocolListCopier.copy(internetFallbackProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetFallbackProtocolsWithStrings(String ... internetFallbackProtocols) {
            this.internetFallbackProtocolsWithStrings(Arrays.asList(internetFallbackProtocols));
            return this;
        }

        @Override
        public final Builder internetFallbackProtocols(Collection<InternetFallbackProtocol> internetFallbackProtocols) {
            this.internetFallbackProtocols = InternetFallbackProtocolListCopier.copyEnumToString(internetFallbackProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetFallbackProtocols(InternetFallbackProtocol ... internetFallbackProtocols) {
            this.internetFallbackProtocols(Arrays.asList(internetFallbackProtocols));
            return this;
        }

        public AccessEndpointConfig build() {
            return new AccessEndpointConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessEndpointConfig> {
        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);

        public Builder internetFallbackProtocolsWithStrings(Collection<String> var1);

        public Builder internetFallbackProtocolsWithStrings(String ... var1);

        public Builder internetFallbackProtocols(Collection<InternetFallbackProtocol> var1);

        public Builder internetFallbackProtocols(InternetFallbackProtocol ... var1);
    }
}

