/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.DataReplication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandbyWorkspacesProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandbyWorkspacesProperties> {
    private static final SdkField<String> STANDBY_WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandbyWorkspaceId").getter(StandbyWorkspacesProperties.getter(StandbyWorkspacesProperties::standbyWorkspaceId)).setter(StandbyWorkspacesProperties.setter(Builder::standbyWorkspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyWorkspaceId").build()}).build();
    private static final SdkField<String> DATA_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataReplication").getter(StandbyWorkspacesProperties.getter(StandbyWorkspacesProperties::dataReplicationAsString)).setter(StandbyWorkspacesProperties.setter(Builder::dataReplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataReplication").build()}).build();
    private static final SdkField<Instant> RECOVERY_SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecoverySnapshotTime").getter(StandbyWorkspacesProperties.getter(StandbyWorkspacesProperties::recoverySnapshotTime)).setter(StandbyWorkspacesProperties.setter(Builder::recoverySnapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoverySnapshotTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDBY_WORKSPACE_ID_FIELD, DATA_REPLICATION_FIELD, RECOVERY_SNAPSHOT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StandbyWorkspacesProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String standbyWorkspaceId;
    private final String dataReplication;
    private final Instant recoverySnapshotTime;

    private StandbyWorkspacesProperties(BuilderImpl builder) {
        this.standbyWorkspaceId = builder.standbyWorkspaceId;
        this.dataReplication = builder.dataReplication;
        this.recoverySnapshotTime = builder.recoverySnapshotTime;
    }

    public final String standbyWorkspaceId() {
        return this.standbyWorkspaceId;
    }

    public final DataReplication dataReplication() {
        return DataReplication.fromValue(this.dataReplication);
    }

    public final String dataReplicationAsString() {
        return this.dataReplication;
    }

    public final Instant recoverySnapshotTime() {
        return this.recoverySnapshotTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standbyWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoverySnapshotTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandbyWorkspacesProperties)) {
            return false;
        }
        StandbyWorkspacesProperties other = (StandbyWorkspacesProperties)obj;
        return Objects.equals(this.standbyWorkspaceId(), other.standbyWorkspaceId()) && Objects.equals(this.dataReplicationAsString(), other.dataReplicationAsString()) && Objects.equals(this.recoverySnapshotTime(), other.recoverySnapshotTime());
    }

    public final String toString() {
        return ToString.builder((String)"StandbyWorkspacesProperties").add("StandbyWorkspaceId", (Object)this.standbyWorkspaceId()).add("DataReplication", (Object)this.dataReplicationAsString()).add("RecoverySnapshotTime", (Object)this.recoverySnapshotTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandbyWorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.standbyWorkspaceId()));
            }
            case "DataReplication": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationAsString()));
            }
            case "RecoverySnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.recoverySnapshotTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StandbyWorkspaceId", STANDBY_WORKSPACE_ID_FIELD);
        map.put("DataReplication", DATA_REPLICATION_FIELD);
        map.put("RecoverySnapshotTime", RECOVERY_SNAPSHOT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandbyWorkspacesProperties, T> g) {
        return obj -> g.apply((StandbyWorkspacesProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String standbyWorkspaceId;
        private String dataReplication;
        private Instant recoverySnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StandbyWorkspacesProperties model) {
            this.standbyWorkspaceId(model.standbyWorkspaceId);
            this.dataReplication(model.dataReplication);
            this.recoverySnapshotTime(model.recoverySnapshotTime);
        }

        public final String getStandbyWorkspaceId() {
            return this.standbyWorkspaceId;
        }

        public final void setStandbyWorkspaceId(String standbyWorkspaceId) {
            this.standbyWorkspaceId = standbyWorkspaceId;
        }

        @Override
        public final Builder standbyWorkspaceId(String standbyWorkspaceId) {
            this.standbyWorkspaceId = standbyWorkspaceId;
            return this;
        }

        public final String getDataReplication() {
            return this.dataReplication;
        }

        public final void setDataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
        }

        @Override
        public final Builder dataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
            return this;
        }

        @Override
        public final Builder dataReplication(DataReplication dataReplication) {
            this.dataReplication(dataReplication == null ? null : dataReplication.toString());
            return this;
        }

        public final Instant getRecoverySnapshotTime() {
            return this.recoverySnapshotTime;
        }

        public final void setRecoverySnapshotTime(Instant recoverySnapshotTime) {
            this.recoverySnapshotTime = recoverySnapshotTime;
        }

        @Override
        public final Builder recoverySnapshotTime(Instant recoverySnapshotTime) {
            this.recoverySnapshotTime = recoverySnapshotTime;
            return this;
        }

        public StandbyWorkspacesProperties build() {
            return new StandbyWorkspacesProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandbyWorkspacesProperties> {
        public Builder standbyWorkspaceId(String var1);

        public Builder dataReplication(String var1);

        public Builder dataReplication(DataReplication var1);

        public Builder recoverySnapshotTime(Instant var1);
    }
}

