/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.GlobalAcceleratorForDirectory;
import software.amazon.awssdk.services.workspaces.model.StorageConnector;
import software.amazon.awssdk.services.workspaces.model.StorageConnectorsCopier;
import software.amazon.awssdk.services.workspaces.model.StreamingExperiencePreferredProtocolEnum;
import software.amazon.awssdk.services.workspaces.model.UserSetting;
import software.amazon.awssdk.services.workspaces.model.UserSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingProperties> {
    private static final SdkField<String> STREAMING_EXPERIENCE_PREFERRED_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamingExperiencePreferredProtocol").getter(StreamingProperties.getter(StreamingProperties::streamingExperiencePreferredProtocolAsString)).setter(StreamingProperties.setter(Builder::streamingExperiencePreferredProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingExperiencePreferredProtocol").build()}).build();
    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserSettings").getter(StreamingProperties.getter(StreamingProperties::userSettings)).setter(StreamingProperties.setter(Builder::userSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageConnectors").getter(StreamingProperties.getter(StreamingProperties::storageConnectors)).setter(StreamingProperties.setter(Builder::storageConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GlobalAcceleratorForDirectory> GLOBAL_ACCELERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlobalAccelerator").getter(StreamingProperties.getter(StreamingProperties::globalAccelerator)).setter(StreamingProperties.setter(Builder::globalAccelerator)).constructor(GlobalAcceleratorForDirectory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalAccelerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_EXPERIENCE_PREFERRED_PROTOCOL_FIELD, USER_SETTINGS_FIELD, STORAGE_CONNECTORS_FIELD, GLOBAL_ACCELERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamingProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String streamingExperiencePreferredProtocol;
    private final List<UserSetting> userSettings;
    private final List<StorageConnector> storageConnectors;
    private final GlobalAcceleratorForDirectory globalAccelerator;

    private StreamingProperties(BuilderImpl builder) {
        this.streamingExperiencePreferredProtocol = builder.streamingExperiencePreferredProtocol;
        this.userSettings = builder.userSettings;
        this.storageConnectors = builder.storageConnectors;
        this.globalAccelerator = builder.globalAccelerator;
    }

    public final StreamingExperiencePreferredProtocolEnum streamingExperiencePreferredProtocol() {
        return StreamingExperiencePreferredProtocolEnum.fromValue(this.streamingExperiencePreferredProtocol);
    }

    public final String streamingExperiencePreferredProtocolAsString() {
        return this.streamingExperiencePreferredProtocol;
    }

    public final boolean hasUserSettings() {
        return this.userSettings != null && !(this.userSettings instanceof SdkAutoConstructList);
    }

    public final List<UserSetting> userSettings() {
        return this.userSettings;
    }

    public final boolean hasStorageConnectors() {
        return this.storageConnectors != null && !(this.storageConnectors instanceof SdkAutoConstructList);
    }

    public final List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public final GlobalAcceleratorForDirectory globalAccelerator() {
        return this.globalAccelerator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingExperiencePreferredProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserSettings() ? this.userSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConnectors() ? this.storageConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.globalAccelerator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingProperties)) {
            return false;
        }
        StreamingProperties other = (StreamingProperties)obj;
        return Objects.equals(this.streamingExperiencePreferredProtocolAsString(), other.streamingExperiencePreferredProtocolAsString()) && this.hasUserSettings() == other.hasUserSettings() && Objects.equals(this.userSettings(), other.userSettings()) && this.hasStorageConnectors() == other.hasStorageConnectors() && Objects.equals(this.storageConnectors(), other.storageConnectors()) && Objects.equals(this.globalAccelerator(), other.globalAccelerator());
    }

    public final String toString() {
        return ToString.builder((String)"StreamingProperties").add("StreamingExperiencePreferredProtocol", (Object)this.streamingExperiencePreferredProtocolAsString()).add("UserSettings", this.hasUserSettings() ? this.userSettings() : null).add("StorageConnectors", this.hasStorageConnectors() ? this.storageConnectors() : null).add("GlobalAccelerator", (Object)this.globalAccelerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingExperiencePreferredProtocol": {
                return Optional.ofNullable(clazz.cast(this.streamingExperiencePreferredProtocolAsString()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
            case "StorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.storageConnectors()));
            }
            case "GlobalAccelerator": {
                return Optional.ofNullable(clazz.cast(this.globalAccelerator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamingExperiencePreferredProtocol", STREAMING_EXPERIENCE_PREFERRED_PROTOCOL_FIELD);
        map.put("UserSettings", USER_SETTINGS_FIELD);
        map.put("StorageConnectors", STORAGE_CONNECTORS_FIELD);
        map.put("GlobalAccelerator", GLOBAL_ACCELERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingProperties, T> g) {
        return obj -> g.apply((StreamingProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamingExperiencePreferredProtocol;
        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();
        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();
        private GlobalAcceleratorForDirectory globalAccelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingProperties model) {
            this.streamingExperiencePreferredProtocol(model.streamingExperiencePreferredProtocol);
            this.userSettings(model.userSettings);
            this.storageConnectors(model.storageConnectors);
            this.globalAccelerator(model.globalAccelerator);
        }

        public final String getStreamingExperiencePreferredProtocol() {
            return this.streamingExperiencePreferredProtocol;
        }

        public final void setStreamingExperiencePreferredProtocol(String streamingExperiencePreferredProtocol) {
            this.streamingExperiencePreferredProtocol = streamingExperiencePreferredProtocol;
        }

        @Override
        public final Builder streamingExperiencePreferredProtocol(String streamingExperiencePreferredProtocol) {
            this.streamingExperiencePreferredProtocol = streamingExperiencePreferredProtocol;
            return this;
        }

        @Override
        public final Builder streamingExperiencePreferredProtocol(StreamingExperiencePreferredProtocolEnum streamingExperiencePreferredProtocol) {
            this.streamingExperiencePreferredProtocol(streamingExperiencePreferredProtocol == null ? null : streamingExperiencePreferredProtocol.toString());
            return this;
        }

        public final List<UserSetting.Builder> getUserSettings() {
            List<UserSetting.Builder> result = UserSettingsCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingsCopier.copyFromBuilder(userSettings);
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingsCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting ... userSettings) {
            this.userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder> ... userSettings) {
            this.userSettings(Stream.of(userSettings).map(c -> (UserSetting)((UserSetting.Builder)UserSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StorageConnector.Builder> getStorageConnectors() {
            List<StorageConnector.Builder> result = StorageConnectorsCopier.copyToBuilder(this.storageConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorsCopier.copyFromBuilder(storageConnectors);
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorsCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder> ... storageConnectors) {
            this.storageConnectors(Stream.of(storageConnectors).map(c -> (StorageConnector)((StorageConnector.Builder)StorageConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GlobalAcceleratorForDirectory.Builder getGlobalAccelerator() {
            return this.globalAccelerator != null ? this.globalAccelerator.toBuilder() : null;
        }

        public final void setGlobalAccelerator(GlobalAcceleratorForDirectory.BuilderImpl globalAccelerator) {
            this.globalAccelerator = globalAccelerator != null ? globalAccelerator.build() : null;
        }

        @Override
        public final Builder globalAccelerator(GlobalAcceleratorForDirectory globalAccelerator) {
            this.globalAccelerator = globalAccelerator;
            return this;
        }

        public StreamingProperties build() {
            return new StreamingProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingProperties> {
        public Builder streamingExperiencePreferredProtocol(String var1);

        public Builder streamingExperiencePreferredProtocol(StreamingExperiencePreferredProtocolEnum var1);

        public Builder userSettings(Collection<UserSetting> var1);

        public Builder userSettings(UserSetting ... var1);

        public Builder userSettings(Consumer<UserSetting.Builder> ... var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder storageConnectors(Consumer<StorageConnector.Builder> ... var1);

        public Builder globalAccelerator(GlobalAcceleratorForDirectory var1);

        default public Builder globalAccelerator(Consumer<GlobalAcceleratorForDirectory.Builder> globalAccelerator) {
            return this.globalAccelerator((GlobalAcceleratorForDirectory)((GlobalAcceleratorForDirectory.Builder)GlobalAcceleratorForDirectory.builder().applyMutation(globalAccelerator)).build());
        }
    }
}

