/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse;

public class DescribeApplicationsIterable
implements SdkIterable<DescribeApplicationsResponse> {
    private final WorkSpacesClient client;
    private final DescribeApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeApplicationsIterable(WorkSpacesClient client, DescribeApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeApplicationsResponseFetcher();
    }

    public Iterator<DescribeApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeApplicationsResponseFetcher
    implements SyncPageFetcher<DescribeApplicationsResponse> {
        private DescribeApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeApplicationsResponse nextPage(DescribeApplicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeApplicationsIterable.this.client.describeApplications(DescribeApplicationsIterable.this.firstRequest);
            }
            return DescribeApplicationsIterable.this.client.describeApplications((DescribeApplicationsRequest)((Object)DescribeApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

