/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBrowserSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListBrowserSettingsResponse.Builder, ListBrowserSettingsResponse> {
    private static final SdkField<List<BrowserSettingsSummary>> BROWSER_SETTINGS_FIELD = SdkField
            .<List<BrowserSettingsSummary>> builder(MarshallingType.LIST)
            .memberName("browserSettings")
            .getter(getter(ListBrowserSettingsResponse::browserSettings))
            .setter(setter(Builder::browserSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrowserSettingsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrowserSettingsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBrowserSettingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SETTINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BrowserSettingsSummary> browserSettings;

    private final String nextToken;

    private ListBrowserSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.browserSettings = builder.browserSettings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BrowserSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBrowserSettings() {
        return browserSettings != null && !(browserSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The browser settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBrowserSettings} method.
     * </p>
     * 
     * @return The browser settings.
     */
    public final List<BrowserSettingsSummary> browserSettings() {
        return browserSettings;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBrowserSettings() ? browserSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrowserSettingsResponse)) {
            return false;
        }
        ListBrowserSettingsResponse other = (ListBrowserSettingsResponse) obj;
        return hasBrowserSettings() == other.hasBrowserSettings() && Objects.equals(browserSettings(), other.browserSettings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBrowserSettingsResponse")
                .add("BrowserSettings", hasBrowserSettings() ? browserSettings() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserSettings":
            return Optional.ofNullable(clazz.cast(browserSettings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBrowserSettingsResponse, T> g) {
        return obj -> g.apply((ListBrowserSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBrowserSettingsResponse> {
        /**
         * <p>
         * The browser settings.
         * </p>
         * 
         * @param browserSettings
         *        The browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettings(Collection<BrowserSettingsSummary> browserSettings);

        /**
         * <p>
         * The browser settings.
         * </p>
         * 
         * @param browserSettings
         *        The browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettings(BrowserSettingsSummary... browserSettings);

        /**
         * <p>
         * The browser settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #browserSettings(List<BrowserSettingsSummary>)}.
         * 
         * @param browserSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #browserSettings(java.util.Collection<BrowserSettingsSummary>)
         */
        Builder browserSettings(Consumer<BrowserSettingsSummary.Builder>... browserSettings);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private List<BrowserSettingsSummary> browserSettings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrowserSettingsResponse model) {
            super(model);
            browserSettings(model.browserSettings);
            nextToken(model.nextToken);
        }

        public final List<BrowserSettingsSummary.Builder> getBrowserSettings() {
            List<BrowserSettingsSummary.Builder> result = BrowserSettingsListCopier.copyToBuilder(this.browserSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrowserSettings(Collection<BrowserSettingsSummary.BuilderImpl> browserSettings) {
            this.browserSettings = BrowserSettingsListCopier.copyFromBuilder(browserSettings);
        }

        @Override
        public final Builder browserSettings(Collection<BrowserSettingsSummary> browserSettings) {
            this.browserSettings = BrowserSettingsListCopier.copy(browserSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSettings(BrowserSettingsSummary... browserSettings) {
            browserSettings(Arrays.asList(browserSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSettings(Consumer<BrowserSettingsSummary.Builder>... browserSettings) {
            browserSettings(Stream.of(browserSettings).map(c -> BrowserSettingsSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBrowserSettingsResponse build() {
            return new ListBrowserSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
