/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.CertificateListCopier;
import software.amazon.awssdk.services.workspacesweb.model.CertificateThumbprintListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrustStoreRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, UpdateTrustStoreRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustStoreArn").getter(UpdateTrustStoreRequest.getter(UpdateTrustStoreRequest::trustStoreArn)).setter(UpdateTrustStoreRequest.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("trustStoreArn").build()}).build();
    private static final SdkField<List<SdkBytes>> CERTIFICATES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificatesToAdd").getter(UpdateTrustStoreRequest.getter(UpdateTrustStoreRequest::certificatesToAdd)).setter(UpdateTrustStoreRequest.setter(Builder::certificatesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CERTIFICATES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificatesToDelete").getter(UpdateTrustStoreRequest.getter(UpdateTrustStoreRequest::certificatesToDelete)).setter(UpdateTrustStoreRequest.setter(Builder::certificatesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateTrustStoreRequest.getter(UpdateTrustStoreRequest::clientToken)).setter(UpdateTrustStoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD, CERTIFICATES_TO_ADD_FIELD, CERTIFICATES_TO_DELETE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTrustStoreRequest.memberNameToFieldInitializer();
    private final String trustStoreArn;
    private final List<SdkBytes> certificatesToAdd;
    private final List<String> certificatesToDelete;
    private final String clientToken;

    private UpdateTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.certificatesToAdd = builder.certificatesToAdd;
        this.certificatesToDelete = builder.certificatesToDelete;
        this.clientToken = builder.clientToken;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final boolean hasCertificatesToAdd() {
        return this.certificatesToAdd != null && !(this.certificatesToAdd instanceof SdkAutoConstructList);
    }

    public final List<SdkBytes> certificatesToAdd() {
        return this.certificatesToAdd;
    }

    public final boolean hasCertificatesToDelete() {
        return this.certificatesToDelete != null && !(this.certificatesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> certificatesToDelete() {
        return this.certificatesToDelete;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificatesToAdd() ? this.certificatesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificatesToDelete() ? this.certificatesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustStoreRequest)) {
            return false;
        }
        UpdateTrustStoreRequest other = (UpdateTrustStoreRequest)((Object)obj);
        return Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && this.hasCertificatesToAdd() == other.hasCertificatesToAdd() && Objects.equals(this.certificatesToAdd(), other.certificatesToAdd()) && this.hasCertificatesToDelete() == other.hasCertificatesToDelete() && Objects.equals(this.certificatesToDelete(), other.certificatesToDelete()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrustStoreRequest").add("TrustStoreArn", (Object)this.trustStoreArn()).add("CertificatesToAdd", this.hasCertificatesToAdd() ? this.certificatesToAdd() : null).add("CertificatesToDelete", this.hasCertificatesToDelete() ? this.certificatesToDelete() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "certificatesToAdd": {
                return Optional.ofNullable(clazz.cast(this.certificatesToAdd()));
            }
            case "certificatesToDelete": {
                return Optional.ofNullable(clazz.cast(this.certificatesToDelete()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("certificatesToAdd", CERTIFICATES_TO_ADD_FIELD);
        map.put("certificatesToDelete", CERTIFICATES_TO_DELETE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustStoreRequest, T> g) {
        return obj -> g.apply((UpdateTrustStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private String trustStoreArn;
        private List<SdkBytes> certificatesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> certificatesToDelete = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustStoreRequest model) {
            super(model);
            this.trustStoreArn(model.trustStoreArn);
            this.certificatesToAdd(model.certificatesToAdd);
            this.certificatesToDelete(model.certificatesToDelete);
            this.clientToken(model.clientToken);
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final List<ByteBuffer> getCertificatesToAdd() {
            if (this.certificatesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificatesToAdd == null ? null : this.certificatesToAdd.stream().map(BytesWrapper::asByteBuffer).collect(Collectors.toList());
        }

        public final void setCertificatesToAdd(Collection<ByteBuffer> certificatesToAdd) {
            this.certificatesToAdd(certificatesToAdd == null ? null : (Collection)certificatesToAdd.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        @Override
        public final Builder certificatesToAdd(Collection<SdkBytes> certificatesToAdd) {
            this.certificatesToAdd = CertificateListCopier.copy(certificatesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesToAdd(SdkBytes ... certificatesToAdd) {
            this.certificatesToAdd(Arrays.asList(certificatesToAdd));
            return this;
        }

        public final Collection<String> getCertificatesToDelete() {
            if (this.certificatesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificatesToDelete;
        }

        public final void setCertificatesToDelete(Collection<String> certificatesToDelete) {
            this.certificatesToDelete = CertificateThumbprintListCopier.copy(certificatesToDelete);
        }

        @Override
        public final Builder certificatesToDelete(Collection<String> certificatesToDelete) {
            this.certificatesToDelete = CertificateThumbprintListCopier.copy(certificatesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesToDelete(String ... certificatesToDelete) {
            this.certificatesToDelete(Arrays.asList(certificatesToDelete));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustStoreRequest build() {
            return new UpdateTrustStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrustStoreRequest> {
        public Builder trustStoreArn(String var1);

        public Builder certificatesToAdd(Collection<SdkBytes> var1);

        public Builder certificatesToAdd(SdkBytes ... var1);

        public Builder certificatesToDelete(Collection<String> var1);

        public Builder certificatesToDelete(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

