/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse;

public class ListNetworkSettingsIterable
implements SdkIterable<ListNetworkSettingsResponse> {
    private final WorkSpacesWebClient client;
    private final ListNetworkSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNetworkSettingsIterable(WorkSpacesWebClient client, ListNetworkSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNetworkSettingsResponseFetcher();
    }

    public Iterator<ListNetworkSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNetworkSettingsResponseFetcher
    implements SyncPageFetcher<ListNetworkSettingsResponse> {
        private ListNetworkSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNetworkSettingsResponse nextPage(ListNetworkSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkSettingsIterable.this.client.listNetworkSettings(ListNetworkSettingsIterable.this.firstRequest);
            }
            return ListNetworkSettingsIterable.this.client.listNetworkSettings((ListNetworkSettingsRequest)((Object)ListNetworkSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

